package DMAAdditionsDeletions;

import java.io.File;
import java.util.*;

/**
 * @author Damla Oguz
 */
class Item implements Comparable<Item> {

    public int id;
    public String name;
    public int count;
    public int idx;
    public boolean hold;
    public int mfiLastLine;

    @Override
    public int compareTo(Item i) {
        if (i.count == count) {
            return name.compareTo(i.name);
        }
        return i.count - count;
    }

    @Override
    public String toString() {
        return name + ":" + count;
    }
}

class ItemNameComparator implements Comparator<Item> {

    @Override
    public int compare(Item t, Item t1) {
        return t.name.compareTo(t1.name);
    }
}

class ItemList {

    public ArrayList<Item> itemList;
    public ArrayList<Item> supportedList;

    public ItemList() {
        itemList = new ArrayList<Item>();
        supportedList = new ArrayList<Item>();
    }

    public void sortItems() {
        Collections.sort(itemList);
    }

    public void createSupportedList(int support) {
        supportedList.clear();
        for (int i = 0; i < itemList.size(); i++) {
            if (itemList.get(i).count >= support) {
                supportedList.add(itemList.get(i));
            }
        }
    }
}

class DBLine {

    public int tid;
    public ArrayList<Item> items;
    public int ste;
    public String itemString;
    public String nameSortedString;

    public DBLine() {
        tid = 0;
        items = new ArrayList<Item>();
        ste = 1;
        itemString = new String();
        nameSortedString = new String();
    }

    public void setNames() {
        for (int i = 0; i < items.size(); i++) {
            itemString += "<" + items.get(i).name + ">";
        }
    }

    public void sortItems() {
        Collections.sort(items);
    }

    public void sortItemsByName() {
        ArrayList<Item> nameSorted = new ArrayList<Item>(items);
        Collections.sort(nameSorted, new ItemNameComparator());
        for (int i = 0; i < nameSorted.size(); i++) {
            nameSortedString += nameSorted.get(i).name;
        }
    }

    public void printLine() {
        System.out.print(tid + ": ");
        for (int i = 0; i < items.size(); i++) {
            System.out.print(items.get(i).name + " ");
        }
        System.out.println(" (" + itemString + ")");
    }
}

class LineDatabase {

    public ArrayList<DBLine> DBase;
    private int support;
    private boolean isSorted;

    public LineDatabase() {
        DBase = new ArrayList<DBLine>();
        support = 0;
        isSorted = false;
    }

    public void sortLineItems() {
        isSorted = true;
    }

    public void sortLineItemsByName() {
        for (int i = 0; i < DBase.size(); i++) {
            DBase.get(i).sortItemsByName();
        }
    }

    public void printDb() {
        for (int i = 0; i < DBase.size(); i++) {
            DBase.get(i).printLine();
        }
    }

    public void setNames() {
        if (!isSorted) {
            sortLineItems();
        }
        for (int i = 0; i < DBase.size(); i++) {
            DBase.get(i).setNames();
        }
    }

    public void calculateSupport() {
        support = 1;
    }

    public void setSupport(int s) {
        support = s;
    }

    public int getSupport() {
        return support;
    }
}

class MFILine {

    public int mid;
    public String itemString;
    public String nameSortedString;
    public int ste;
    public ArrayList<Integer> values;

    MFILine() {
        mid = 0;
        ste = 1;
        itemString = new String();
        nameSortedString = new String();
        values = new ArrayList<Integer>();
    }

    public void printLine() {
        System.out.print(mid + ": ");
        for (int i = 0; i < values.size(); i++) {
            System.out.print(" " + values.get(i) + "  ");
        }
        System.out.println(" " + ste);
    }
}

class MFI {

    public ArrayList<Item> itemSet;
    public ArrayList<MFILine> lines;
    public ArrayList<FrequentItem> freqItems;
    public int support;
    private int sayac;

    MFI(ArrayList<Item> supportedList) {
        itemSet = new ArrayList<Item>(supportedList);
        lines = new ArrayList<MFILine>();
        freqItems = new ArrayList<FrequentItem>();
        MFILine ilk = new MFILine();
        ilk.mid = 1;
        for (int i = 0; i < itemSet.size(); i++) {
            ilk.values.add(0);
        }
        lines.add(ilk);
        sayac = 1;
    }

    public void printMFI() {
        System.out.print("   ");
        for (int i = 0; i < itemSet.size(); i++) {
            System.out.print(itemSet.get(i).name + " ");
        }
        System.out.println(" STE");
        for (int i = 0; i < lines.size(); i++) {
            lines.get(i).printLine();
        }
    }

    public void createMFI(ArrayList<DBLine> dBase) {
        for (int i = 0; i < dBase.size(); i++) {
            boolean yok = true;
            for (int j = 1; j < lines.size(); j++) {
                if (dBase.get(i).itemString.equals(lines.get(j).itemString)) {
                    lines.get(j).ste++;
                    yok = false;
                    break;
                }
            }

            if (yok) {
                boolean enAzBiriVar = false;
                MFILine yeni = new MFILine();
                yeni.itemString = dBase.get(i).itemString;
                yeni.nameSortedString = dBase.get(i).nameSortedString;
                for (int k = 0; k < itemSet.size(); k++) {
                    String kon = itemSet.get(k).name;
                    if (dBase.get(i).itemString.contains(kon)) {
                        yeni.values.add(1);
                        itemSet.get(k).mfiLastLine = sayac;
                        enAzBiriVar = true;
                    } else {
                        yeni.values.add(0);
                    }
                }
                if (enAzBiriVar) {
                    sayac++;
                    yeni.mid = sayac;
                    lines.add(yeni);
                }
            }
        }
    }

    public void modifyMFI() {
        for (int i = 0; i < itemSet.size(); i++) {
            int onceki = 0;
            for (int j = 1; j < lines.size(); j++) {
                if (lines.get(j).values.get(i) == 1) {
                    lines.get(onceki).values.set(i, lines.get(j).mid);
                    onceki = j;
                }
            }
        }
    }

    public void printFreqItems() {
        for (int i = 0; i < freqItems.size(); i++) {
            freqItems.get(i).printFreqItem();
        }
    }

    public void calculateFreqs() {
        this.freqItems.clear();
        int basla = 0;
        for (int i = 0; i < itemSet.size(); i++) {
            if (itemSet.get(i).count >= support) {
                basla = i;
            }
        }
        for (int i = basla; i > 0; i--) {
            FrequentItem curr = new FrequentItem();
            curr.items.add(itemSet.get(i));
            curr.itemIds.add(i);
            curr.count = 0;
            calculateFreqs(curr, i - 1);

        }
    }

    private void calculateFreqs(FrequentItem curr, int i) {
        boolean test = true;
        if (i == 0) {
            test = false;
        }
        for (int j = i; j >= 0; j--) {
            FrequentItem c = new FrequentItem(curr);
            c.items.add(itemSet.get(j));
            c.itemIds.add(j);
            c.count = 0;
            if (countFreqs(c)) {
                if (test) {
                    calculateFreqs(c, j - 1);
                }
            }
        }
    }

    public boolean countFreqs(FrequentItem curr) {
        int satir = 0;
        boolean done = true;
        while (done) {
            int enBuyuk = lines.get(satir).values.get(curr.itemIds.get(0));
            boolean hepsiVar = true;
            for (int i = 0; i < curr.itemIds.size(); i++) {
                int c = lines.get(satir).values.get(curr.itemIds.get(i));
                if (c > enBuyuk) {
                    enBuyuk = c;
                }
                if (c == 0) {
                    hepsiVar = false;
                }
                if (c == 1) {
                    done = false;
                }
            }
            if (hepsiVar) {
                curr.count += lines.get(satir).ste;
            }
            if (done) {
                satir = enBuyuk - 1;
            }
        }

        curr.count = curr.count - 1;
        if (curr.count >= support) {
            freqItems.add(new FrequentItem(curr));
            return true;
        } else {
            return false;
        }
    }

    void update(ArrayList<DBLine> dBase, ArrayList<Item> supportedList) {
        int yeniCount = 0;
        for (int j = 0; j < supportedList.size(); j++) {
            boolean yeniSup = true;
            for (int i = 0; i < itemSet.size(); i++) {
                if (supportedList.get(j).name.equals(itemSet.get(i).name)) {
                    yeniSup = false;
                }
            }
            if (yeniSup) {
                itemSet.add(supportedList.get(j));
                yeniCount++;
            }
        }

        for (int j = 0; j < lines.size(); j++) {
            for (int i = 0; i < yeniCount; i++) {
                lines.get(j).values.add(0);
            }
        }

        for (int i = 0; i < dBase.size(); i++) {
            boolean yok = true;
            for (int j = 1; j < lines.size(); j++) {

                if (dBase.get(i).nameSortedString.compareTo(lines.get(j).nameSortedString) == 0) {
                    lines.get(j).ste++;
                    yok = false;
                    break;
                }
            }

            if (yok) {
                MFILine yeni = new MFILine();
                yeni.itemString = dBase.get(i).itemString;
                yeni.nameSortedString = dBase.get(i).nameSortedString;
                for (int k = 0; k < itemSet.size(); k++) {
                    String kon = itemSet.get(k).name;
                    if (dBase.get(i).itemString.contains(kon)) {
                        yeni.values.add(1);

                        lines.get(itemSet.get(k).mfiLastLine).values.set(k, sayac + 1);
                        itemSet.get(k).mfiLastLine = sayac;
                    } else {
                        yeni.values.add(0);
                    }
                }
                sayac++;
                yeni.mid = sayac;
                lines.add(yeni);
            }
        }

        ArrayList<Integer> mapping = new ArrayList<Integer>();
        for (int i = 0; i < supportedList.size(); i++) {
            for (int j = 0; j < itemSet.size(); j++) {
                if (supportedList.get(i).name.compareTo(itemSet.get(j).name) == 0) {
                    mapping.add(j);
                }
            }
        }

        for (int i = 0; i < lines.size(); i++) {
            ArrayList<Integer> temp = new ArrayList<Integer>(lines.get(i).values);
            lines.get(i).values.clear();

            for (int j = 0; j < mapping.size(); j++) {
                lines.get(i).values.add(temp.get(mapping.get(j)));
            }
        }

        itemSet.clear();
        itemSet.addAll(supportedList);
    }

    void deletionUpdate(ArrayList<DBLine> dBase2, ArrayList<Item> supportedList) {
        for (int k = 0; k < dBase2.size(); k++) {
            boolean yok = true;
            for (int j = 1; j < lines.size(); j++) {
                if (dBase2.get(k).nameSortedString.compareTo(lines.get(j).nameSortedString) == 0) {
                    lines.get(j).ste--;

                    yok = false;
                    break;
                }
            }
            if (yok) {
                System.err.println("The line to be deleted does not exist in the database.");
                break;
            }
        }

        ArrayList<Integer> mapping = new ArrayList<Integer>();
        for (int i = 0; i < supportedList.size(); i++) {
            for (int j = 0; j < itemSet.size(); j++) {
                if (supportedList.get(i).name.compareTo(itemSet.get(j).name) == 0) {
                    mapping.add(j);
                }
            }
        }

        for (int i = 0; i < lines.size(); i++) {
            ArrayList<Integer> temp = new ArrayList<Integer>(lines.get(i).values);
            lines.get(i).values.clear();

            for (int j = 0; j < mapping.size(); j++) {
                lines.get(i).values.add(temp.get(mapping.get(j)));
            }
        }

        itemSet.clear();
        itemSet.addAll(supportedList);

    }
}

class FrequentItem {

    public ArrayList<Item> items;
    public ArrayList<Integer> itemIds;
    public int count;

    FrequentItem() {
        items = new ArrayList<Item>();
        itemIds = new ArrayList<Integer>();
        count = 0;
    }

    FrequentItem(FrequentItem f) {
        items = new ArrayList<Item>(f.items);
        itemIds = new ArrayList<Integer>(f.itemIds);
        count = f.count;
    }

    void printFreqItem() {
        for (int i = items.size() - 1; i >= 0; i--) {
            System.out.print(items.get(i).name);
        }
        System.out.println(": " + count);
    }

    @Override
    public String toString() {
        String temp = "";
        for (int i = items.size() - 1; i >= 0; i--) {
            temp += items.get(i).name;
        }
        return temp + ": " + Integer.toString(count);
    }
}

class DataFileParser {

    private File dosya;

    public DataFileParser() {
    }

    public void Parse(String fname, ItemList itemIdList, LineDatabase db) {
        Parse(fname, itemIdList, db, false);
    }

    public void Parse(String fname, ItemList itemIdList, LineDatabase db, boolean toDelete) {
        dosya = new File(fname);
        try {
            Scanner in = new Scanner(dosya);
            String temp;
            boolean devam = true;
            while (in.hasNextLine() && devam) {
                temp = in.next();
                if (temp.equals("BEGIN_DATA")) {
                    devam = false;
                    continue;
                }
            }

            devam = true;
            int sayac = 1;
            while (in.hasNextLine() && devam) {
                temp = in.nextLine();
                if (temp.equals("END_DATA")) {
                    devam = false;
                    continue;
                }
                if (temp.equals("")) {
                    continue;
                }

                DBLine lineTemp = new DBLine();
                lineTemp.tid = sayac;

                String[] r = temp.split(" ");
                for (int i = 0; i < r.length; i++) {
                    int deger = Integer.parseInt(r[i]);
                    boolean varMi = false;
                    Iterator<Item> lit = itemIdList.itemList.iterator();
                    while (lit.hasNext()) {
                        Item tempIt = lit.next();
                        if (tempIt.id == deger) {
                            varMi = true;
                            if (toDelete) {
                                tempIt.count--;
                            } else {
                                tempIt.count++;
                            }
                            lineTemp.items.add(tempIt);
                        }
                    }
                    if (!varMi) {
                        Item it = new Item();
                        it.count = 1;
                        it.id = deger;
                        it.name = "<C" + deger + ">";
                        itemIdList.itemList.add(it);
                        lineTemp.items.add(it);
                    }
                }
                db.DBase.add(lineTemp);
                if (!toDelete) {
                    sayac++;
                }
            }
            in.close();
        } catch (Exception e) {
            System.out.println(e.toString());
            return;
        }
    }
}

public class DMAAdditionsDeletions {

    public static void main(String[] args) {

        if (args.length != 6) {
            System.err.println("Please give arguments for "
                    + "[INITIAL DATASET PATH] [SUPPORT] "
                    + "[ADDITION DATASET PATH] [SUPPORT AFTER ADDITIONS] "
                    + "[DELETION DATASET PATH] [SUPPORT AFTER DELETIONS]");
            return;
        }

        String initialDataPath = args[0];
        int initialMinSupport = Integer.parseInt(args[1]);
        String additions = args[2];
        int additionMinSupport = Integer.parseInt(args[3]);
        String deletions = args[4];
        int deletionMinSupport = Integer.parseInt(args[5]);


        int ortalama = 0;
        System.out.println("DYNAMIC MATRIX APRIORI");
        for (int ii = 0; ii < 1; ii++) {

            ItemList itemIdList = new ItemList();
            LineDatabase db = new LineDatabase();
            DataFileParser df = new DataFileParser();
            df.Parse(initialDataPath, itemIdList, db);

            db.setNames();
            db.sortLineItemsByName();
            db.calculateSupport();
            itemIdList.sortItems();
            itemIdList.createSupportedList(db.getSupport());

            MFI mfi = new MFI(itemIdList.supportedList);
            mfi.support = initialMinSupport;
            mfi.createMFI(db.DBase);
            mfi.modifyMFI();

            long start = System.currentTimeMillis();
            LineDatabase yenidb = new LineDatabase();
            df.Parse(additions, itemIdList, yenidb);

            yenidb.setNames();
            yenidb.sortLineItemsByName();
            itemIdList.sortItems();
            itemIdList.createSupportedList(db.getSupport());

            mfi.support = additionMinSupport;
            mfi.update(yenidb.DBase, itemIdList.supportedList);
            System.out.println("Items: " + itemIdList.itemList.size());

            // DELETION
            LineDatabase silinecekler = new LineDatabase();
            df.Parse(deletions, itemIdList, silinecekler, true);
            silinecekler.setNames();
            silinecekler.sortLineItemsByName();
            itemIdList.sortItems(); //
            itemIdList.createSupportedList(db.getSupport());
            mfi.support = deletionMinSupport;
            mfi.deletionUpdate(silinecekler.DBase, itemIdList.supportedList);
            mfi.calculateFreqs();
            long end = System.currentTimeMillis();
            ortalama += (end - start);
            System.out.println("Frequent itemsets (after deletion): " + mfi.freqItems.size());
            //mfi.printFreqItems(); 
        }
        System.out.println("Update time: " + (ortalama / 1));
    }
}
